#include <stdlib.h>
#include <stdio.h>

struct vec {
    int *data;
    int count;
};

// Common:
int vec_count(struct vec *v) {
    return v->count;
}

int vec_get(struct vec *v, int pos) {
    return v->data[pos];
}

void vec_set(struct vec *v, int pos, int value) {
    v->data[pos] = value;
}

void vec_print(struct vec *v) {
    for (int i = 0; i < vec_count(v); i++)
        printf("%2d: %2d\n", i, vec_get(v, i));
}

// External allocation:
void vec_init(struct vec *v, int count) {
    v->data = malloc(sizeof(int) * count);
    v->count = count;
}

void vec_destroy(struct vec *v) {
    free(v->data);
}

// Internal allocation:
struct vec *vec_create(int count) {
    struct vec *v = malloc(sizeof(int) * count);
    v->data = malloc(sizeof(int) * count);
    v->count = count;
    return v;
}

void vec_free(struct vec *v) {
    free(v->data);
    free(v);
}

// Usage example:
int main(void) {
    // Using external allocation:
    {
        struct vec v;
        vec_init(&v, 2);
        vec_set(&v, 0, 1);
        vec_set(&v, 1, 2);
        vec_print(&v);
        vec_destroy(&v);
    }

    // Using internal allocation:
    {
        struct vec *v = vec_create(2);
        vec_set(v, 0, 1);
        vec_set(v, 1, 2);
        vec_print(v);
        vec_free(v);
    }
    return 0;
}
