#include <stdio.h>
#include "thread.h"
#include "synch.h"

int result;
struct semaphore has_result;
struct semaphore access_result;

int expensive_computations(int x) {
    // Simulate time-consuming computations.
    timer_msleep(1000);
    return x;
}

void thread_fn(void) {
    for (int i = 0; i < 4; i++) {
        int to_add = expensive_computations(2);
        sema_down(&access_result);
        result += to_add;
        sema_up(&access_result);
    }
    sema_up(&has_result);
}

int main(void) {
    sema_init(&has_result, 0);
    sema_init(&access_result, 1);
    thread_new(&thread_fn);
    for (int i = 0; i < 4; i++) {
        int to_add = expensive_computations(5);
        sema_down(&access_result);
        result += to_add;
        sema_up(&access_result);
    }
    sema_down(&has_result);
    sema_down(&access_result);
    printf("result=%d\n", result);
    sema_up(&access_result);
    return 0;
}
