#include <stdio.h>
#include "thread.h"
#include "synch.h"

int counter = 0;

struct semaphore counter_lock;

void update_counter(int delta) {
    if (delta != 0) {
        sema_down(&counter_lock);
        counter += delta;
    }
    sema_up(&counter_lock);
}

void thread_main(void) {
    update_counter(0);

    for (int i = 0; i < 2; i++)
        update_counter(1);
}

int main(void) {
    sema_init(&counter_lock, 1);

    thread_new(&update_counter);

    for (int i = 0; i < 2; i++)
        update_counter(-1);

    return 0;
}
