#include <stdio.h>
#include "thread.h"
#include "synch.h"

int result;
struct semaphore has_result;
struct lock result_lock;

int expensive_computations(int x) {
    // Simulate time-consuming computations.
    timer_msleep(1000);
    return x;
}

void thread_fn(void) {
    for (int i = 0; i < 4; i++) {
        int to_add = expensive_computations(2);
        lock_acquire(&result_lock);
        result += to_add;
        lock_release(&result_lock);
    }
    sema_up(&has_result);
}

int main(void) {
    sema_init(&has_result, 0);
    lock_init(&result_lock);
    thread_new(&thread_fn);
    for (int i = 0; i < 4; i++) {
        int to_add = expensive_computations(5);
        lock_acquire(&result_lock);
        result += to_add;
        lock_release(&result_lock);
    }
    sema_down(&has_result);
    lock_acquire(&result_lock);
    printf("result=%d\n", result);
    lock_release(&result_lock);
    return 0;
}
