#include <stdio.h>
#include "thread.h"
#include "synch.h"

int result_a;
int result_b;
bool a_done;
bool b_done;
struct lock done_lock;
struct semaphore has_result;

void thread_fn_a(void) {
    for (int i = 0; i < 4; i++) {
        result_a += 2;
    }
    lock_acquire(&done_lock);
    a_done = true;
    lock_release(&done_lock);
    sema_up(&has_result);
}

void thread_fn_b(void) {
    for (int i = 0; i < 4; i++) {
        result_b += 3;
    }
    lock_acquire(&done_lock);
    b_done = true;
    lock_release(&done_lock);
    sema_up(&has_result);
}

int main(void) {
    sema_init(&has_result, 0);
    thread_new(&thread_fn_a);
    thread_new(&thread_fn_b);

    sema_down(&has_result);
    lock_acquire(&done_lock);
    if (a_done)
        printf("result_a=%d\n", result_a);
    else
        printf("result_b=%d\n", result_b);
    lock_release(&done_lock);

    sema_down(&has_result);
    printf("result_b=%d\n", result_b);
    // ...

    return 0;
}
