#include <stdio.h>
#include <stdlib.h>
#include "thread.h"
#include "synch.h"

struct account {
    int balance;
};

int accounts_count;
struct account *accounts;

bool transfer(int amount, int from, int to) {
    struct account *f = &accounts[from];
    struct account *t = &accounts[to];

    bool ok = f->balance >= amount;
    if (ok)
        f->balance -= amount;
    if (ok)
        t->balance += amount;
    return ok;
}

void create_accounts(int count, int initial_balance) NO_STEP {
    accounts = malloc(sizeof(struct account) * count);
    accounts_count = count;
    for (int i = 0; i < count; i++) {
        accounts[i].balance = initial_balance;
    }
}

struct semaphore thread_done;

void thread_main(void) {
    transfer(8, 0, 1);
    sema_up(&thread_done);
}

int main(void) {
    sema_init(&thread_done, 0);
    create_accounts(2, 10);

    for (int i = 0; i < 2; i++)
        thread_new(&thread_main);

    for (int i = 0; i < 2; i++)
        sema_down(&thread_done);

    assert(accounts[0].balance >= 0);
    return 0;
}
