#include <stdio.h>
#include <stdlib.h>
#include "thread.h"
#include "synch.h"

struct account {
    int balance;
    struct lock balance_from_lock;
    struct lock balance_to_lock;
};

int accounts_count;
struct account *accounts;

bool transfer(int amount, int from, int to) {
    struct account *f = &accounts[from];
    struct account *t = &accounts[to];

    lock_acquire(&f->balance_from_lock);
    bool ok = f->balance >= amount;
    if (ok)
        f->balance -= amount;
    lock_release(&f->balance_from_lock);

    if (ok) {
        lock_acquire(&t->balance_to_lock);
        t->balance += amount;
        lock_release(&t->balance_to_lock);
    }
    return ok;
}

void create_accounts(int count, int initial_balance) NO_STEP {
    accounts = malloc(sizeof(struct account) * count);
    accounts_count = count;
    for (int i = 0; i < count; i++) {
        accounts[i].balance = initial_balance;
        lock_init(&accounts[i].balance_from_lock);
        lock_init(&accounts[i].balance_to_lock);
    }
}

struct semaphore thread_done;

void thread2_main(void) {
    transfer(8, 0, 1);
    sema_up(&thread_done);
}

void thread3_main(void) {
    transfer(8, 0, 2);
}

void thread4_main(void) {
    transfer(8, 2, 3);
    sema_up(&thread_done);
}

int main(void) {
    sema_init(&thread_done, 0);
    create_accounts(4, 10);

    thread_new(&thread2_main);
    thread_new(&thread3_main);
    thread_new(&thread4_main);

    for (int i = 0; i < 3; i++)
        sema_down(&thread_done);

    assert(accounts[0].balance > 0);
    return 0;
}
