#include <stdio.h>
#include <stdlib.h>
#include "thread.h"
#include "synch.h"

struct account {
    int balance;
};

int accounts_count;
struct account *accounts;
struct lock accounts_lock;

bool transfer(int amount, int from, int to) {
    struct account *f = &accounts[from];
    struct account *t = &accounts[to];

    lock_acquire(&accounts_lock);
    bool ok = f->balance >= amount;
    if (ok)
        f->balance -= amount;
    if (ok)
        t->balance += amount;
    lock_release(&accounts_lock);
    return ok;
}

int accounts_total(void) {
    int total = 0;
    lock_acquire(&accounts_lock);
    for (int i = 0; i < accounts_count; i++) {
        total += accounts[i].balance;
    }
    lock_release(&accounts_lock);
    return total;
}

void create_accounts(int count, int initial_balance) NO_STEP {
    lock_init(&accounts_lock);
    accounts = malloc(sizeof(struct account) * count);
    accounts_count = count;
    for (int i = 0; i < count; i++) {
        accounts[i].balance = initial_balance;
    }
}

struct semaphore thread_done;

void thread_main(void) {
    transfer(5, 0, 1);
    sema_up(&thread_done);
}

int main(void) {
    sema_init(&thread_done, 0);
    create_accounts(2, 10);

    for (int i = 0; i < 2; i++)
        thread_new(&thread_main);

    int total = accounts_total();
    assert(total == 2 * 10);

    for (int i = 0; i < 2; i++)
        sema_down(&thread_done);

    return 0;
}
