#include <stdio.h>
#include "thread.h"
#include "synch.h"

int counter = 10;
struct lock counter_lock;

void decrease(int with) {
    lock_acquire(&counter_lock);
    if (counter >= with)
        counter -= with;
    lock_release(&counter_lock);
}

struct semaphore thread_done;

void thread_main(void) {
    decrease(6);
    sema_up(&thread_done);
}

int main(void) {
    sema_init(&thread_done, 0);
    lock_init(&counter_lock);

    for (int i = 0; i < 2; i++)
        thread_new(&thread_main);

    for (int i = 0; i < 2; i++)
        sema_down(&thread_done);

    assert(counter == 4);
    return 0;
}
