#include <stdio.h>
#include "thread.h"
#include "synch.h"

struct semaphore done;

const int times = 4;
int result = 0;
struct lock result_lock;

void thread_a(void) {
    for (int i = 0; i < times; i++) {
        lock_acquire(&result_lock);
        int tmp = result;
        lock_release(&result_lock);
        tmp += 2;
        lock_acquire(&result_lock);
        result = tmp;
        lock_release(&result_lock);
    }
    sema_up(&done);
}

void thread_b(void) {
    for (int i = 0; i < times; i++) {
        lock_acquire(&result_lock);
        result += 5;
        lock_release(&result_lock);
    }
    sema_up(&done);
}

int main(void) {
    sema_init(&done, 0);
    lock_init(&result_lock);
    thread_new(&thread_a);
    thread_new(&thread_b);

    sema_down(&done);
    sema_down(&done);
    printf("result=%d\n", result);
    // Uncomment to use Run -> Look for errors to
    // find incorrect behavior:
    // assert(result == times * (2 + 5));
    return 0;
}
