#include <stdio.h>
#include "thread.h"
#include "synch.h"

int counter = 10;
struct lock decrease_lock;
struct lock increase_lock;

void decrease(int with) {
    lock_acquire(&decrease_lock);
    if (counter >= with)
        counter -= with;
    lock_release(&decrease_lock);
}

void increase(int with) {
    lock_acquire(&increase_lock);
    counter += with;
    lock_acquire(&increase_lock);
}

struct semaphore thread_done;

void thread_main(void) {
    decrease(6);
    sema_up(&thread_done);
}

int main(void) {
    lock_init(&decrease_lock);
    lock_init(&increase_lock);
    sema_init(&thread_done, 0);

    for (int i = 0; i < 2; i++)
        thread_new(&thread_main);

    increase(1);

    for (int i = 0; i < 2; i++)
        sema_down(&thread_done);

    assert(counter == 5);
    return 0;
}
