#include <stdio.h>
#include <stdlib.h>
#include "thread.h"
#include "synch.h"

struct account {
    int balance;
    struct lock balance_lock;
};

int accounts_count;
struct account *accounts;

bool transfer(int amount, int from, int to) {
    struct account *f = &accounts[from];
    struct account *t = &accounts[to];

    lock_acquire(&f->balance_lock);
    lock_acquire(&t->balance_lock);

    bool ok = f->balance >= amount;
    if (ok)
        f->balance -= amount;
    if (ok)
        t->balance += amount;

    lock_release(&t->balance_lock);
    lock_release(&f->balance_lock);
    return ok;
}

int accounts_total(void) {
    int total = 0;

    for (int i = 0; i < accounts_count; i++)
        lock_acquire(&accounts[i].balance_lock);

    for (int i = 0; i < accounts_count; i++) {
        total += accounts[i].balance;
        lock_release(&accounts[i].balance_lock);
    }

    return total;
}

void create_accounts(int count, int initial_balance) NO_STEP {
    accounts = malloc(sizeof(struct account) * count);
    accounts_count = count;
    for (int i = 0; i < count; i++) {
        accounts[i].balance = initial_balance;
        lock_init(&accounts[i].balance_lock);
    }
}

struct semaphore thread_done;

void thread_main(void) {
    transfer(5, 1, 0);
    sema_up(&thread_done);
}

int main(void) {
    sema_init(&thread_done, 0);
    create_accounts(2, 10);

    thread_new(&thread_main);

    transfer(5, 0, 1);

    sema_down(&thread_done);
    return 0;
}
