#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include "thread.h"
#include "synch.h"

bool *seat_taken;
int *seat_used_count;
int num_seats;

int seat_acquire(void) {
    int taken = -1;
    while (taken == -1) {
        for (int i = 0; i < num_seats; i++) {
            if (seat_taken[i] == false) {
                seat_taken[i] = true;
                taken = i;
                break;
            }
        }
    }
    return taken;
}

void seat_release(int id) {
    seat_taken[id] = false;
}

void init_seats(int count) NO_STEP {
    seat_taken = malloc(sizeof(bool) * count);
    seat_used_count = malloc(sizeof(int) * count);
    num_seats = count;
    for (int i = 0; i < count; i++) {
        seat_taken[i] = false;
        seat_used_count[i] = 0;
    }
}

struct semaphore threads_done;

void thread_fn() {
    int seat = seat_acquire();
    seat_used_count[seat]++;
    seat_release(seat);

    sema_up(&threads_done);
}

int main(void) {
    sema_init(&threads_done, 0);
    init_seats(2);

    thread_new(&thread_fn);
    thread_new(&thread_fn);
    thread_fn();

    for (int i = 0; i < 3; i++)
        sema_down(&threads_done);

    int total = 0;
    for (int i = 0; i < num_seats; i++) {
        total += seat_used_count[i];
    }
    assert(total == 3);

    return 0;
}
