#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include "thread.h"
#include "synch.h"

bool *seat_taken;
int *seat_used_count;
int num_seats;
struct lock seat_taken_lock;
struct condition seat_free_cond;

static bool grab_seat(int *taken) {
    for (int i = 0; i < num_seats; i++) {
        if (seat_taken[i] == false) {
            seat_taken[i] = true;
            *taken = i;
            return true;
        }
    }
    return false;
}

int seat_acquire(void) {
    int taken = -1;
    lock_acquire(&seat_taken_lock);
    while (!grab_seat(&taken))
        cond_wait(&seat_free_cond, &seat_taken_lock);
    lock_release(&seat_taken_lock);
    return taken;
}

void seat_release(int id) {
    lock_acquire(&seat_taken_lock);
    seat_taken[id] = false;
    cond_signal(&seat_free_cond, &seat_taken_lock);
    lock_release(&seat_taken_lock);
}

void init_seats(int count) NO_STEP {
    lock_init(&seat_taken_lock);
    cond_init(&seat_free_cond);
    seat_taken = malloc(sizeof(bool) * count);
    seat_used_count = malloc(sizeof(int) * count);
    num_seats = count;
    for (int i = 0; i < count; i++) {
        seat_taken[i] = false;
        seat_used_count[i] = 0;
    }
}

struct semaphore threads_done;

void thread_fn() {
    int seat = seat_acquire();
    seat_used_count[seat]++;
    seat_release(seat);

    sema_up(&threads_done);
}

int main(void) {
    sema_init(&threads_done, 0);
    init_seats(2);

    thread_new(&thread_fn);
    thread_new(&thread_fn);
    thread_fn();

    for (int i = 0; i < 3; i++)
        sema_down(&threads_done);

    int total = 0;
    for (int i = 0; i < num_seats; i++) {
        total += seat_used_count[i];
    }
    assert(total == 3);

    return 0;
}
