#include "thread.h"
#include "synch.h"

struct condition cond;
struct lock cond_lock;

void thread_fn(void) {
    lock_acquire(&cond_lock);
    cond_wait(&cond, &cond_lock);
    lock_release(&cond_lock);
}

int main(void) {
    cond_init(&cond);
    lock_init(&cond_lock);

    thread_new(&thread_fn);
    thread_new(&thread_fn);
    thread_new(&thread_fn);

    lock_acquire(&cond_lock);
    cond_signal(&cond, &cond_lock);
    lock_release(&cond_lock);

    lock_acquire(&cond_lock);
    cond_broadcast(&cond, &cond_lock);
    lock_release(&cond_lock);

    return 0;
}
