#pragma once
#include "os.h"

#ifdef POSIX

#define test_and_set(value)                     \
    __sync_fetch_and_or(value, 1)

#define atomic_swap(value, replace)             \
    __sync_lock_test_and_set(value, replace)

#define atomic_swap_ptr(value, replace)         \
    __sync_lock_test_and_set(value, replace)

#define compare_and_swap(value, compare, swap)  \
    __sync_val_compare_and_swap(value, compare, swap)

#define compare_and_swap_ptr(value, compare, swap)      \
    __sync_val_compare_and_swap(value, compare, swap)

#define atomic_add(value, add)                  \
    __sync_fetch_and_add(value, add)

#define atomic_sub(value, sub)                  \
    __sync_fetch_and_sub(value, sub)

#define atomic_read(value)                      \
    __sync_val_compare_and_swap(value, 0, 0)

#define atomic_write(value, write)              \
    ((void)__sync_lock_test_and_set(value, write))

#endif


#ifdef WIN32

static int test_and_set(int volatile *value) {
    return _InterlockedOr(value, 1);
}

static int atomic_swap(int volatile *value, int replace) {
    return InterlockedExchange(value, replace);
}

static void *atomic_swap_ptr(void *volatile *value, void *replace) {
    return InterlockedExchangePointer(value, replace);
}

static int compare_and_swap(int volatile *value, int compare, int swap) {
    return InterlockedCompareExchange(value, swap, compare);
}

static void *compare_and_swap_ptr(void *volatile *value, void *compare, void *swap) {
    return InterlockedCompareExchangePointer(value, swap, compare);
}

static int atomic_add(int volatile *value, int add) {
    return InterlockedExchangeAdd(value, add);
}

static int atomic_sub(int volatile *value, int sub) {
    return InterlockedExchangeSubtract(value, sub);
}

static void atomic_write(int volatile *value, int store) {
    atomic_swap(value, store);
}

static void atomic_write_ptr(void *volatile *value, void *store) {
    atomic_swap_ptr(value, store);
}

#endif


#define atomics_busy_wait() do {} while (false)
