#pragma once
#include "os.h"

typedef void thread_func(void *aux);
tid_t thread_create(const char *name, int priority, thread_func *fn, void *aux);

#if 0
// Same as above, but simpler. Below are a few macros that implement a version of the function here
// that accepts a variable number of pointer arguments.
tid_t thread_new(thread_func *fn, void *aux);
#endif

tid_t thread_current(void);
void thread_exit(void);
void thread_yield(void);

void timer_msleep(unsigned milliseconds);


// "thread_new" implemented with macros, so that we can pass any pointer type to the function, just
// like in Progvis. We support up to 5 parameters.
#define PICK_SEVENTH(A, B, C, D, E, F, G, ...) G
#define NUM_ARGS(...) PICK_SEVENTH(__VA_ARGS__, 6, 5, 4, 3, 2, 1)
#define THREAD_NEW_NAME_2(NUM) thread_new_ ## NUM
#define THREAD_NEW_NAME(NUM) THREAD_NEW_NAME_2(NUM)

#define thread_new(...) THREAD_NEW_NAME(NUM_ARGS(__VA_ARGS__)) (__VA_ARGS__)


// The functions that are actually called by thread_new above.
tid_t thread_new_1(void *fn);
tid_t thread_new_2(void *fn, void *a);
tid_t thread_new_3(void *fn, void *a, void *b);
tid_t thread_new_4(void *fn, void *a, void *b, void *c);
tid_t thread_new_5(void *fn, void *a, void *b, void *c, void *d);
tid_t thread_new_6(void *fn, void *a, void *b, void *c, void *d, void *e);
